/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_rom ( q, inclock, outclock, memenab, address) ;

  parameter lpm_type = "lpm_rom" ;
  parameter lpm_width    = 1 ;
  parameter lpm_widthad = 1 ;
  parameter lpm_numwords = 1<< lpm_widthad ;
  parameter lpm_file       = "rom.hex" ;
  parameter lpm_outdata    = "REGISTERED" ;
  parameter lpm_addr_control = "REGISTERED" ;
  parameter polar_data     = "NORMAL" ;
  parameter polar_inclock  = "NORMAL" ;
  parameter polar_outclock = "NORMAL" ;
  parameter polar_we       = "NORMAL" ;
  parameter polar_memenab  = "NORMAL" ;
  parameter polar_address  = "NORMAL" ;
  parameter polar_q        = "NORMAL" ;

  input  [lpm_widthad-1:0] address ;
  input  inclock, outclock ;
  input  memenab ;
  output [lpm_width-1:0] q;


  // inernal reg 
  reg   [lpm_width-1:0] memROM [lpm_numwords-1:0];
  reg   [lpm_widthad-1:0] paddress ;
  reg   [lpm_widthad-1:0] paddress_in ;
  reg   [lpm_width-1:0] tmp_q ;
  reg   pinclock, poutclock ;
  reg   pmemenab ;
  reg   [lpm_width-1:0] ONES, ZEROS, UNKNOWN, HiZ ;
  reg [8*256:1] rom_initf ;
  integer i ;

  pullup   P3 ( memenab) ;


  function ValidAddress ;
	input [lpm_widthad-1:0] paddress ;
	begin
		ValidAddress = 1'b0 ;
		if(^paddress ==='bx)
			$display("%d:Error: Invalid address.", $time) ;
		else if(paddress >= lpm_numwords)
			$display("%d:Error: Address out of bound on ROM.", $time) ;
		else
			ValidAddress = 1'b1 ;
	end
  endfunction
		
  initial
  begin

	if(lpm_file === "")
		$display("Error! rom module must have data file for initialization\n.");

    // check for number of words out of bound.
    if(lpm_numwords > (1 << lpm_widthad))
	begin
        $display("Error! Too many words defined.\n");
		$stop;
	end
 
    // check if lpm_addr_control is set to registered
    // inclock must be used.
    if((lpm_addr_control === "REGISTERED") && (inclock === 1'bz))
    begin
        $display("Error! inclock = 1'bz.  Inclock pin must be used.\n");
    end
 
    // check if lpm_outdata, outclock must be used
    if((lpm_outdata === "REGISTERED") && (outclock === 1'bz))
    begin
        $display("Error! lpm_outdata is REGISTERED, outclock = 1'bz.  Outclock must be used.\n");
    end

	for(i=0; i < lpm_width; i=i+1)
	begin
		ONES[i] = 1'b1 ;
		ZEROS[i] = 1'b0 ;
		UNKNOWN[i] = 1'bX ;
		HiZ[i] = 1'bZ ;
	end	
	
	for(i = 0; i < lpm_numwords; i=i+1)
		memROM[i] = ZEROS ;

	// load data to the ROM
	if(lpm_file != "")
	begin
`ifdef SYNTH
`else
     $convert_hex2ver(lpm_file, lpm_width, rom_initf);
`endif
		$readmemh(rom_initf, memROM);
	end
  end

  always @(inclock)
      pinclock <= #1 (polar_inclock == "INVERT")?~inclock:inclock;
    
  always @(outclock)
      poutclock <= #1 (polar_outclock == "INVERT")?~outclock:outclock;
   
  always @(memenab)
	pmemenab <= #1 (polar_memenab == "INVERT")?~memenab:memenab;

  always @(address)
	paddress_in <= #1 (polar_address == "INVERT")?~address:address;
	
  always @( paddress_in or pmemenab )
    begin

      	if (!pmemenab)
			tmp_q = HiZ ;
		else
		begin

        	if(lpm_addr_control === "UNREGISTERED")
        	begin
            	paddress = paddress_in ;
        	end

			if(lpm_outdata === "UNREGISTERED")
			begin
      			if (pmemenab)
				begin
					if(ValidAddress(paddress))
						tmp_q = memROM[paddress] ;
					else
						tmp_q = UNKNOWN ;
				end
			end
		end
	end

  always @(posedge pinclock)
    begin
        if(lpm_addr_control === "REGISTERED")
        begin
            paddress = paddress_in ;
        end
    end

  always @(posedge poutclock)
    begin
        if(lpm_outdata === "REGISTERED")
        begin
      		if (pmemenab)
			begin
				if(ValidAddress(paddress))
					#0 tmp_q = memROM[paddress] ;
				else
					tmp_q = UNKNOWN ;
			end
        end
    end
		
  assign q = (polar_q == "INVERT")?~tmp_q:tmp_q ;

endmodule // lpm_rom
`ifdef SYNTH
`else
`endcelldefine
`endif
 
